function startPeriodicCall(fn, timeout)
{
    var fnWrapper = function ()
    {
        fn();
        setTimeout(fnWrapper, timeout);
    };

    fnWrapper();
}

var app = {

    doUrl: location.href.substring(0, location.href.indexOf(location.pathname)) + '/cgi-bin/do',
    do2Url: location.href.substring(0, location.href.indexOf(location.pathname)) + '/cgi-bin/do2',

    keys: {

        play:    'B748BF00',
        pause:   'E11EBF00',
        stop:    'E619BF00',
        prev:    'B649BF00',
        next:    'E21DBF00',
        volUp:   'AD52BF00',
        volDown: 'AC53BF00',
        topMenu: 'AE51BF00',
        mute:    'B946BF00'
    },

    init: function()
          {
              $('a[data-toggle="tab"]').on('shown',
                                           function (e)
                                           {
                                               if (e.target.hash === '#tools') settings.loadOptions();

                                               if (e.target.hash === '#player'
                                                       || $('a[href="#player"]').parent().hasClass('active'))
                                               {
                                                   if ($('a[href="#player_ctrl"]').parent().hasClass('active')) player.start();
                                                   else player.stop();

                                                   if ($('a[href="#player_playlist"]').parent().hasClass('active')) playlist.start();
                                                   else playlist.stop();
                                               }
                                               else
                                               {
                                                   player.stop();
                                                   playlist.stop();
                                               }

                                               if (e.target.hash === '#browser_network'
                                                       || e.target.hash === '#browser_local'
                                                       || e.target.hash === '#browser_favorite') browser.clearFileList();

                                           } );

              $('#check_for_updates_button').on('click', function(){app.checkForUpdates();});

              this.loadAppInfo();
          },

    ajaxGet: function(url, data, responseHandler, errorHandler)
             {
                 var eh, rh;
                 if (typeof errorHandler === 'function') eh = function(jqXHR){app.ajaxError(jqXHR, errorHandler);};
                 else eh = $.proxy(this.ajaxError, this);

                 if (typeof responseHandler === 'function') rh = function(data) { responseHandler(data); app.ajaxResponseHandler(data); };
                 else rh = $.proxy(this.ajaxResponseHandler, this);

                 loader.show();
                 $.get(url, data, rh).error(eh);
             },

    ajaxGetJSON: function(url, data, responseHandler, errorHandler)
                 {
                     var eh, rh;
                     if (typeof errorHandler === 'function') eh = function(jqXHR){app.ajaxError(jqXHR, errorHandler);};
                     else eh = $.proxy(this.ajaxError, this);

                     if (typeof responseHandler === 'function') rh = function(data) { responseHandler(data); app.ajaxResponseHandler(data) };
                     else rh = $.proxy(this.ajaxResponseHandler, this);

                     loader.show();
                     $.getJSON(url, data, rh).error(eh);
                 },

    ajaxPost: function(url, data, responseHandler, errorHandler)
              {
                  var eh, rh;
                  if (typeof errorHandler === 'function') eh = function(jqXHR){app.ajaxError(jqXHR, errorHandler);};
                  else eh = $.proxy(this.ajaxError, this);

                  if (typeof responseHandler === 'function') rh = function(data) { responseHandler(data); app.ajaxResponseHandler(data) };
                  else rh = $.proxy(this.ajaxResponseHandler, this);

                  loader.show();
                  $.post(url, data, rh).error(eh);
              },

    play: function(playPath)
          {
              this.ajaxGet(this.do2Url,
                           {
                               cmd: 'player',
                               action: 'play',
                               play_path: playPath
                           });
          },

    remoteControl: function(keyCode, responseHandler)
                   {
                       if (typeof responseHandler !== 'function') responseHandler = function() {};
                       this.ajaxGet(this.doUrl,
                                    {
                                        cmd: 'ir_code',
                                        ir_code: keyCode
                                    },
                                    responseHandler);
                   },

    checkForUpdates: function(silentMode)
                     {
                         if (typeof silentMode === 'undefined') silentMode = false;

                         this.ajaxGetJSON(this.do2Url,
                                          {
                                              cmd: 'check_new_version',
                                              silent_mode: silentMode ? 1 : 0
                                          },

                                          $.proxy(this.processCheckForUpdatesResponse, this));
                     },

    processCheckForUpdatesResponse: function(data)
                                    {
                                        var currVersion = '0.0.0';
                                        var lastVersion = '0.0.0';
                                        var description = '';
                                        var silentMode = true;
                                        if ('currentVersionNumber' in data) currVersion = data.currentVersionNumber;
                                        if ('versionNumber' in data) lastVersion = data.versionNumber;
                                        if ('description' in data) description = data.description;
                                        if ('silentMode' in data) silentMode = data.silentMode === 'true';

                                        var currVerArr = currVersion.split('.');
                                        var lastVerArr = lastVersion.split('.');

                                        if (currVerArr.length !== 3 || lastVerArr.length !== 3)
                                        {
                                            if(!silentMode) alert('error');
                                            return;
                                        }

                                        var nCurrVer =  parseInt(currVerArr[0] * 10000 + currVerArr[1] * 100 + currVerArr[2]);
                                        var nLastVer =  parseInt(lastVerArr[0] * 10000 + lastVerArr[1] * 100 + lastVerArr[2]);

                                        if (nCurrVer < nLastVer)
                                        {
                                            newVersionInfoDlg.show(currVersion, lastVersion, description);
                                        }
                                        else
                                        {
                                            if(!silentMode) alert('No new version');
                                        }
                                    },

    ajaxResponseHandler: function(data)
                         {
                             loader.hide();
                         },

    ajaxError: function(jqXHR, customHandler)
               {
                   loader.hide();

                   if (jqXHR.responseText === '')
                   {
//                       this.reset();
                   }
                   else
                   {
                       if (typeof customHandler === 'function') customHandler(jqXHR);
                       else alert(jqXHR.responseText);
                   }
               },

    loadAppInfo: function()
                 {
                     this.ajaxGetJSON(this.do2Url,
                                      {
                                          cmd: 'app_info'
                                      },
                                      $.proxy(this.processAppInfoResponse, this) );
                 },

    processAppInfoResponse: function(data)
                            {
                                $('#current_version_message').text(data.version);
                                var nnvc = parseFloat(data.nnvc);
                                if (nnvc < new Date().getTime() / 1000) this.checkForUpdates(true);
                            },

    reset: function()
           {
               this.ajaxGet(this.do2Url + '?restore');
           }
}

var browser = {

    storagesCont: null,
    networkSourcesCont: null,
    favoriteCont: null,
    dirCtrl: null,
    currDirCont: null,
    pathHistory: null,
    historyBackBtn: null,
    playCurrDirBtn: null,
    currDirLabelCont: null,
    currentDir: null,

    tplStorageButton: '<button class="btn btn-primary btn-large"></button>',
    tplStorageButtonSeparator: '<div class="storage-button-separator"></div>',

    tplNetworkSourceButton: '<div class="btn-toolbar"><div class="btn-group"><button class="btn btn-primary btn-large main"></button></div>'
                            + '</div>',

    tplNetworkSourceDelButton: '<div class="btn-group"><button class="btn btn-danger btn-large delete"><i class="icon-remove"></i></button></div>',

    tplFavoriteButton: '<div class="btn-toolbar"><div class="btn-group"><button class="btn btn-primary btn-large main"></button></div>'
                       + '<div class="btn-group"><button class="btn btn-danger btn-large delete"><i class="icon-remove"></i></button></div>'
                       + '</div>',

    tplFile: '<tr><td class="ctrl"></td><td class="name"></td></tr>',
    tplDirUrl: '<a href="javascript:"></a>',
    tplPlayButton: '<button class="btn btn-success btn-small btn-play">Play</button>',

    init: function()
          {
              this.storagesCont = $('#storages_cont');
              this.networkSourcesCont = $('#network_sources_cont');
              this.favoriteCont = $('#favorite_cont');
              this.currDirCont = $('#curr_dir_cont');
              this.dirCtrl = $('#curr_dir_ctrl');

              this.historyBackBtn = $('#dir_ctrl_history_back');
              this.historyBackBtn.on('click', $.proxy(this.historyGoBack, this));

              this.playCurrDirBtn = $('#dir_ctrl_play_curr_dir');
              this.playCurrDirBtn.on('click', $.proxy(this.playCurrDir, this));

              this.currDirLabelCont = $('#dir_ctrl_curr_dir_label');

              this.dirCtrlShow(false);
              this.currDirShow(false);

              $('#refresh_btn').on('click', this.refreshStoragesList);
              $('#dir_ctrl_add_to_fav').on('click', $.proxy(this.showAddFavoriteDlg, this));

              this.updateLocalStorages();
              this.updateNetworkSources();
              this.updateFavoriteList();

              this.reinitContext();
          },

    updateLocalStorages: function()
                         {
                             app.ajaxGetJSON(app.do2Url,
                                             {
                                                 cmd: 'storage_list'
                                             },

                                             $.proxy(this.processStorageList, this));
                         },

    updateNetworkSources: function()
                          {
                              app.ajaxGetJSON(app.do2Url,
                                              {
                                                  cmd: 'network_source_list'
                                              },

                                              $.proxy(this.processNetworkSourceList, this));
                          },

    updateFavoriteList: function()
                        {
                            app.ajaxGetJSON(app.do2Url,
                                            {
                                                cmd: 'favorite_list'
                                            },

                                            $.proxy(this.processFavoriteList, this));
                        },

    reinitContext: function()
                   {
                       this.currentDir = {
                           path: null,
                           playPath: null,
                           hasSubdir: false
                       };

                       this.pathHistory = [];
                   },

    refreshStoragesList: function()
                         {
                             app.remoteControl(app.keys.topMenu,
                                               function()
                                               {
                                                   document.location.reload();
                                               } );
                         },

    processStorageList: function(data)
                        {
                            this.storagesCont.empty();

                            if (data.storages.length === 0)
                            {
                                var refresh = $(this.tplStorageButton);
                                refresh.text('NO STORAGES! REFRESH');
                                refresh.on('click', this.refreshStoragesList);

                                this.storagesCont.append(refresh);
                                return;
                            }

                            for (var i = 0; i < data.storages.length; ++i)
                            {
                                if (i > 0)
                                {
                                    var sep = $(this.tplStorageButtonSeparator);
                                    this.storagesCont.append(sep);
                                }

                                var s = data.storages[i];
                                var btn = $(this.tplStorageButton);
                                btn.text(s.title);
                                btn.data('path', s.name);
                                btn.on('click', function()
                                       {
                                           browser.reinitContext();
                                           browser.showDir($(this).data('path'));
                                       } );


                                this.storagesCont.append(btn);
                            }
                        },

    processNetworkSourceList: function(data)
                              {
                                  this.networkSourcesCont.empty();

                                  if (data.sources.length === 0)
                                  {
                                      var add = $(this.tplStorageButton);
                                      add.text('ADD SOURCE');
                                      add.on('click',
                                             function(){ $('#add_network_source_dlg').modal('show')});

                                      this.networkSourcesCont.append(add);
                                      return;
                                  }

                                  for (var i = 0; i < data.sources.length; ++i)
                                  {
                                      if (i > 0)
                                      {
                                          var sep = $(this.tplStorageButtonSeparator);
                                          this.networkSourcesCont.append(sep);
                                      }

                                      var s = data.sources[i];
                                      var btnGroup = $(this.tplNetworkSourceButton);

                                      var btn = btnGroup.find('.main');
                                      btn.text(s.title + ' (' + s.type + ')');
                                      btn.data('path', s.name);
                                      btn.on('click', function()
                                             {
                                                 browser.reinitContext();
                                                 browser.showDir($(this).data('path'));
                                             } );

                                      if (s.is_persist === '0')
                                      {
                                          var delGroup = $(this.tplNetworkSourceDelButton);
                                          var del = delGroup.find('.delete');
                                          del.data('network_source_key', s.key);
                                          del.on('click', function()
                                                 {
                                                     browser.delNetworkSource($(this).data('network_source_key'))
                                                 } );

                                          btnGroup.append(del);
                                      }

                                      this.networkSourcesCont.append(btnGroup);
                                  }
                              },

    processFavoriteList: function(data)
                         {
                             this.favoriteCont.empty();

                             for (var i = 0; i < data.favorite.length; ++i)
                             {
                                 if (i > 0)
                                 {
                                     var sep = $(this.tplStorageButtonSeparator);
                                     this.favoriteCont.append(sep);
                                 }

                                 var f = data.favorite[i];
                                 var btnGroup = $(this.tplFavoriteButton);

                                 var btn = btnGroup.find('.main');
                                 btn.text(f.name);
                                 btn.data('path', f.path);
                                 btn.on('click', function()
                                        {
                                            browser.reinitContext();
                                            var path = $(this).data('path');
                                            var pathPieces = path.split('/');
                                            for (var i = 1; i < pathPieces.length - 1; ++i)
                                            { // хак, конечно, ну да ладно
                                                var p = [];
                                                for (var j = 0; j <= i; ++j) p.push(pathPieces[j]);
                                                browser.pathHistory.push(p.join('/'));
                                            }
                                            browser.showDir(path);
                                        } );

                                 var del = btnGroup.find('.delete');
                                 del.data('vaforite_name', f.name);
                                 del.on('click', function()
                                        {
                                            browser.delFavorite($(this).data('vaforite_name'))
                                        } );

                                 this.favoriteCont.append(btnGroup);
                             }
                         },

    delNetworkSource: function(key)
                      {
                          if (window.confirm('Are you sure?'))
                          {
                              app.ajaxGetJSON(app.do2Url,
                                              {
                                                  cmd: 'network_source_del',
                                                  source_key: key
                                              },
                                              $.proxy(this.updateNetworkSources, this));
                          }
                      },

    delFavorite: function(name)
                 {
                     if (window.confirm('Are you sure?'))
                     {
                         app.ajaxGetJSON(app.do2Url,
                                         {
                                             cmd: 'favorite_del',
                                             name: name
                                         },
                                         $.proxy(this.updateFavoriteList, this));
                     }
                 },

    processFileList: function(data)
                     {
                         this.currDirCont.empty();
                         this.currDirShow(true);

                         for (var i = 0; i < data.files.length; ++i)
                         {
                             var f = data.files[i];

                             var item = $(this.tplFile);
                             var itemIsDir = false;

                             if ('path' in f)
                             {
                                 itemIsDir = true;

                                 var a = $(this.tplDirUrl);
                                 a.text(f.name);

                                 var $fnCont = item.find('.name');
                                 $fnCont.data('path', f.path);
                                 $fnCont.on('click', function()
                                            {
                                                browser.showDir($(this).data('path'));
                                            } );

                                 if ('cover' in f)
                                 {
                                     var $table = $('<table class="twc"><tr><td class="cover"></td><td class="name"></td></tr></table>');

                                     $table.find('.cover').append($('<img src="' + f.cover +'" class="cover" />'));
                                     $table.find('.name').append(a);

                                     $fnCont.append($table);
                                 }
                                 else
                                 {
                                     $fnCont.append(a);
                                 }

                                 this.currentDir.hasSubdir = true;
                             }
                             else
                             {
                                 item.find('.name').text(f.name);
                             }

                             var play = null;
                             if ('play_path' in f)
                             {
                                 play = $(this.tplPlayButton);
                                 if (itemIsDir) play.text('Play Directory');

                                 play.data('play_path', f.play_path);
                                 play.on('click', function()
                                         {
                                             app.play($(this).data('play_path'));
                                         } );

                                 item.find('.ctrl').append(play);
                             }

                             this.currDirCont.append(item);

                             this.moveToFiles();
                         }

                         this.setCurrDirPlayPath(data.currDirPlayPath);
                     },

    showDir: function(path, back)
             {
                 if (typeof(back) === 'undefined') back = false;

                 if (!back && this.currentDir.path !== null) this.pathHistory.push(this.currentDir.path);
                 this.currentDir.path = path;

                 this.historyBackShow(this.pathHistory.length > 0);
                 this.currDirLabelCont.text(path.split('/').pop());

                 app.ajaxGetJSON(app.do2Url,
                                 {
                                     cmd: 'file_list',
                                     path: path

                                 },
                                 $.proxy(this.processFileList, this),
                                 $.proxy(this.processInvalidPath, this));
             },

    processInvalidPath: function(jqXHR)
                        {
                            alert(jqXHR.responseText);
                            if (this.pathHistory.length === 0) this.clearFileList();
                            else this.historyGoBack();
                        },

    clearFileList: function()
                   {
                       this.currDirShow(false);
                       this.currDirCont.empty();
                       this.reinitContext();
                   },

    historyGoBack: function()
                   {
                       if (this.pathHistory.length === 0) return;

                       this.showDir(this.pathHistory.pop(), true);
                   },

    playCurrDir: function()
                 {
                     app.play(this.currentDir.playPath);
                 },

    dirCtrlShow: function(show)
                 {
                     if (show) this.dirCtrl.show();
                     else this.dirCtrl.hide();
                 },

    currDirShow: function(show)
                 {
                     if (show) this.currDirCont.parent().show();
                     else this.currDirCont.parent().hide();
                 },

    updateDirCtrlState: function()
                        {
                            var btns = this.dirCtrl.children('button');
                            this.dirCtrlShow(true);
                            for (var i = 0; i < btns.length; ++i)
                            {
                                if ($(btns[i]).is(':visible')) return;
                            }

                            this.dirCtrlShow(false);
                        },

    historyBackShow: function(show)
                     {
                         if (show) this.historyBackBtn.show();
                         else this.historyBackBtn.hide();

                         this.updateDirCtrlState();
                     },

    setCurrDirPlayPath: function(playPath)
                        {
                            this.currentDir.playPath = playPath;
                            this.playCurrDirShow(this.currentDir.playPath !== '');
                        },

    playCurrDirShow: function(show)
                     {
                         if (show) this.playCurrDirBtn.show();
                         else this.playCurrDirBtn.hide();

                         this.updateDirCtrlState();
                     },

    moveToFiles: function()
                 {
                     var loc = document.location + '';
                     if (loc.indexOf('#files') === -1) loc += '#files';
                     document.location = loc;
                 },

    showAddFavoriteDlg: function()
                        {
                            addFavoriteDlg.show(this.currentDir.path);
                        }
};

var addFavoriteDlg = {

    path: null,
    $dlg: null,
    $favName: null,

    init: function()
          {
              this.$dlg = $('#add_favorite_dlg');
              this.$favName = $('#favorite_name');

              $('#add_favorite_button').on('click', $.proxy(this.addFavorite, this));
          },

    show: function(path)
          {
              this.path = path;
              this.$favName.val(this.path.split('/').pop());

              this.$dlg.modal();
          },

    addFavorite: function()
                 {
                     app.ajaxGetJSON(app.do2Url,
                                     {
                                         cmd: 'favorite_add',
                                         name: this.$favName.val(),
                                         path: this.path
                                     },
                                     $.proxy(this.processAddFavoriteResponse, this) );
                 },

    processAddFavoriteResponse: function(data)
                                {
                                    if ('message' in data && data.message === 'ok')
                                    {
                                        browser.updateFavoriteList();
                                        this.$dlg.modal('hide');
                                    }
                                    else
                                    {
                                        alert('error');
                                    }
                                }

};

var addNetworkSourceDlg = {

    $type: null,
    $title: null,
    $address: null,
    $path: null,
    $user: null,
    $password: null,
    $protocol: null,

    init: function()
          {
              this.$type = $('#network_source_type');
              this.$title = $('#network_source_title');
              this.$address = $('#network_source_address');
              this.$path = $('#network_source_path');
              this.$user = $('#network_source_user');
              this.$password = $('#network_source_password');
              this.$protocol = $('#network_source_protocol');

              $('#add_network_source_dlg').on('show', $.proxy(this.show, this));
              $('#network_source_type').on('change', $.proxy(this.initState, this));

              $('#network_source_add_btn').on('click', $.proxy(this.addNetworkSource, this));
          },

    show: function()
          {
              this.clear();
              this.initState();
          },

    clear: function()
           {
               this.$type.val('0');
               this.$title.val('');
               this.$address.val('');
               this.$path.val('');
               this.$user.val('');
               this.$password.val('');
               this.$protocol.val('0');
           },

    initState: function()
               {
                   if (this.$type.val() === '0')
                   {
                       this.$protocol.hide();
                       this.$user.show();
                       this.$password.show();
                   }
                   else
                   {
                       this.$protocol.show();
                       this.$user.hide();
                       this.$password.hide();
                   }
               },

    addNetworkSource: function()
                      {
                          app.ajaxGetJSON(app.do2Url,
                                          {
                                              cmd: 'network_source_add',
                                              type: this.$type.val(),
                                              title: this.$title.val(),
                                              address: this.$address.val(),
                                              path: this.$path.val(),
                                              user: this.$user.val(),
                                              password: this.$password.val(),
                                              protocol: this.$protocol.val()
                                          },

                                          $.proxy(this.processAddNetworkSourceResponse, this) );
                      },

    processAddNetworkSourceResponse: function()
                                     {
                                         browser.updateNetworkSources();
                                         $('#add_network_source_dlg').modal('hide');
                                     },
};

var player = {

    progress: null,
    progressBar: null,
    currentTrackLabel: null,
    volumeLabel: null,
    counter: null,

    currentTrack: '',
    volume: 0,
    duration: 0,
    position: 0,
    mute: false,

    timer: null,

    $playerState: null,
    $playbackState: null,
    $playerStateMainBlock: null,

    muteicon: null,

    init: function()
          {
              this.counter = $('#player_timer');
              this.progressBar = $('#progress_bar');
              this.progress = $('#progress');
              this.volumeLabel = $('#vol_label');
              this.currentTrackLabel = $('#curr_track_label');

              this.$playerState = $('#player_state');
              this.$playbackState = $('#playback_state');
              this.$playerStateMainBlock = $('#player_state_block');

              this.muteicon = $('#mute i')[0];

              var btnClick = function() { app.remoteControl($(this).data('key_code')); }
              $('#play').data('key_code',  app.keys.play).on('click',  btnClick);
              $('#pause').data('key_code', app.keys.pause).on('click', btnClick);
              $('#stop').data('key_code',  app.keys.stop).on('click',  btnClick);
              $('#prev').data('key_code',  app.keys.prev).on('click',  btnClick);
              $('#next').data('key_code',  app.keys.next).on('click',  btnClick);
              $('#mute').data('key_code',  app.keys.mute).on('click',  btnClick);

              $('body').on('click.button.data-api', '[data-ppos]',
                           function(e){ player.addPosition($(this).data('ppos')); });

              $('body').on('click.button.data-api', '[data-pvol]',
                           function(e){ player.addVolume($(this).data('pvol')); });

              $('#poweron').on('click', $.proxy(this.dunePowerOn, this));

              this.progress.on('click', function(e){
                                   player.setPosition(e.clientX - $(this).offset().left, this.offsetWidth);
                               });

              startPeriodicCall($.proxy(this.updateTopPlayerStateBlock, this), 60 * 1000);
          },

    setPosition: function(pos, from)
                 {
                     var newpos = Math.floor(pos * 100 / from);
                     app.ajaxGet(app.do2Url,
                                 {
                                     cmd: 'player',
                                     action: 'moveto',
                                     position: newpos
                                 });
                 },

    addPosition: function(dxPos)
                 {
                     app.ajaxGet(app.do2Url,
                                  {
                                      cmd: 'player',
                                      action: 'addpos',
                                      value: dxPos
                                  });
                 },

    addVolume: function(dxVol)
               {
                   app.ajaxGet(app.do2Url,
                               {
                                   cmd: 'player',
                                   action: 'addvol',
                                   value: dxVol
                               });
               },

    setProgress: function(percents)
                 {
                     this.progressBar.css({width: percents + '%'});
                 },

    setProgress2: function(val, from)
                  {
                      this.setProgress(Math.floor(val * 100 / from));
                  },

    processPlayerState: function(data)
                        {
                            var params = data.getElementsByTagName('param');
                            for (var i = 0; i < params.length; ++i)
                            {
                                var pName = params[i].getAttribute('name');
                                var pVal = params[i].getAttribute('value');
                                switch (pName)
                                {
                                case 'playback_volume':
                                    this.volume = parseInt(pVal);
                                    break;

                                case 'playback_position':
                                    this.position = parseInt(pVal);
                                    break;

                                case 'playback_duration':
                                    this.duration = parseInt(pVal);
                                    break;

                                case 'playback_url':
                                    this.currentTrack = pVal.split('/').pop();
                                    break;

                                case 'playback_mute':
                                    this.mute = pVal === '1';
                                    break;
                                }
                            }

                            this.updateUi();
                        },

    updateUi: function()
              {
                  this.setProgress2(this.position, this.duration);
                  this.volumeLabel.text('Vol. ' + this.volume + '%');
                  this.currentTrackLabel.text(this.currentTrack);
                  this.muteicon.className = this.mute ? 'icon-volume-up' : 'icon-volume-off';

                  // ---- counter
                  var result = '';
                  var h = Math.floor(this.position / (60 * 60));
                  var m = Math.floor( (this.position - h * 60 * 60) / 60);
                  var s = this.position - h * 60 * 60 - m * 60;
                  if (h < 10) h = '0' + h;
                  if (m < 10) m = '0' + m;
                  if (s < 10) s = '0' + s;

                  result += h + ':' + m + ':' + s;

                  h = Math.floor(this.duration / (60 * 60));
                  m = Math.floor( (this.duration - h * 60 * 60) / 60);
                  s = this.duration - h * 60 * 60 - m * 60;
                  if (h < 10) h = '0' + h;
                  if (m < 10) m = '0' + m;
                  if (s < 10) s = '0' + s;

                  result += ' / ' + h + ':' + m + ':' + s;
                  this.counter.text(result);

              },

    updateTopPlayerStateBlock: function()
                               {
                                   app.ajaxGet(app.doUrl,
                                               {
                                                   cmd: 'status'
                                               },
                                               $.proxy(this.processStateResponseTopBlock, this));
                               },

    processStateResponseTopBlock: function(data)
                                  {
                                      this.$playerState.text('');
                                      this.$playbackState.text('');

                                      var params = data.getElementsByTagName('param');
                                      for (var i = 0; i < params.length; ++i)
                                      {
                                          var pName = params[i].getAttribute('name');
                                          var pVal = params[i].getAttribute('value');
                                          switch (pName)
                                          {
                                          case 'player_state':
                                              this.$playerState.text(pVal);
                                              if (pVal === 'standby') this.$playerStateMainBlock.addClass('alert-error');
                                              else this.$playerStateMainBlock.removeClass('alert-error');
                                              break;

                                          case 'playback_state':
                                              this.$playbackState.text(pVal);
                                              break;
                                          }
                                      }
                                  },

    start: function()
           {
               if (this.timer !== null) return;

               this._playerProcess();
           },

    _playerProcess: function()
                    {
                        app.ajaxGet(app.doUrl,
                                    {
                                        cmd: 'status'
                                    },
                                    function(data)
                                    {
                                        player.processPlayerState(data);
                                        player._playerProcessWrapper();
                                    } );
                    },

    _playerProcessWrapper: function()
                           {
                               this.timer = setTimeout(this._playerProcess, 3000);
                           },

    stop: function()
          {
              if (this.timer === null) return;

              clearTimeout(this.timer);
              this.timer = null;

              this.duration = 0;
              this.position = 0;
              this.updateUi();
          },

    dunePowerOn: function()
             {
                     app.ajaxGetJSON(app.do2Url,
                                     {
                                         cmd: 'player',
                                         action: 'poweron'
                                     },
                                     function()
                                     {
                                         document.location.reload();
                                     })
             }
};

var playlist = {

    $cont: null,

    currentHash: '',

    timer: null,

    tplItem: '<li><a href="javascript:{}"></a></li>',
    tplSubitemsCont: '<ul class="unstyled playlist-subitems"></ul>',
    tplSubitem: '<li><a href="javascript:{}"></a></li>',

    init: function()
          {
              this.$cont = $('#playlist_cont');
          },

    moveTo: function(index)
            {
                app.ajaxGet(app.do2Url,
                            {
                                cmd: 'player',
                                action: 'playlist_move',
                                position: index
                            },
                            $.proxy(this.expressUpdate, this));
            },

    updateState: function(items)
                 {
                     var i,j;
                     var itemsCount = 0;
                     for (i = 0; i < items.length; ++i)
                     {
                         ++itemsCount;
                         if ('subitems' in items[i])  itemsCount += items[i].subitems.length;
                     }

                     var domItems = this.$cont[0].getElementsByTagName('li');
                     if (domItems.length !== itemsCount)
                     {
                         this.stop();
                         this.start();
                         return;
                     }

                     var di = 0;
                     for (i = 0; i < items.length; ++i, ++di)
                     {
                         var item = items[i];
                         var domItemT = domItems[di].getElementsByTagName('a')[0];
                         if (item.play) domItemT.className = 'playlist-played-item';
                         else domItemT.className = '';

                         if ('subitems' in item)
                         {
                             ++di;
                             for (j = 0; j < item.subitems.length; ++j, ++di)
                             {
                                 var domSubitemT = domItems[di].getElementsByTagName('a')[0];
                                 if (item.subitems[j].play) domSubitemT.className = 'playlist-played-item';
                                 else domSubitemT.className = '';
                             }
                             --di;
                         }
                     }
                 },

    processPlaylistResponse: function(data)
                             {
                                 if ( !('desc' in data) || !('items' in data) )
                                 {
                                     this.$cont.empty();
                                     return;
                                 }

                                 if (data.desc.hash === this.currentHash)
                                 {
                                     this.updateState(data.items);
                                     return;
                                 }

                                 this.currentHash = data.desc.hash;

                                 for (var i = 0; i < data.items.length; ++i)
                                 {
                                     var item = data.items[i];

                                     var $item = $(this.tplItem);
                                     var $itemT = $item.children('a');
                                     $item.data('index', item.index);
                                     $itemT.text(item.title);
                                     if (item.play) $itemT.addClass('playlist-played-item');

                                     $item.on('click', function(e) { playlist.moveTo($(this).data('index')); } );

                                     if ('subitems' in item)
                                     {
                                         var $subitemsCont = $(this.tplSubitemsCont);
                                         for (var j = 0; j < item.subitems.length; ++j)
                                         {
                                             var subitem = item.subitems[j];

                                             var $subitem = $(this.tplSubitem);
                                             var $subitemT = $subitem.children('a');
                                             $subitemT.text(subitem.title);
                                             $subitem.data('index', subitem.index);
                                             if (subitem.play) $subitemT.addClass('playlist-played-item');

                                             $subitem.on('click', function(e) { playlist.moveTo($(this).data('index')); e.stopPropagation(); } );

                                             $subitemsCont.append($subitem);
                                         }

                                         $item.append($subitemsCont);
                                     }

                                     this.$cont.append($item);
                                 }
                             },

    start: function()
           {
               if (this.timer !== null) return;

               this._playlistProcess();
           },

    expressUpdate: function()
                   {
                       if (this.timer !== null)
                       {
                           clearTimeout(this.timer);
                           this.timer = null;
                       }

                       this._playlistProcess();
                   },

    _playlistProcess: function()
                      {
                          app.ajaxGet(app.do2Url,
                                      {
                                          cmd: 'player',
                                          action: 'playlist'
                                      },
                                      function(data)
                                      {
                                          playlist.processPlaylistResponse(data);
                                          playlist._playlistProcessWrapper();
                                      } );
                      },

    _playlistProcessWrapper: function()
                             {
                                 this.timer = setTimeout(this._playlistProcess, 10000);
                             },

    stop: function( )
          {
              if (this.timer === null) return;

              clearTimeout(this.timer);
              this.timer = null;

              this.currentHash = '';
              this.$cont.empty();
          }
};

var RcBtn = function(left, top, right, bottom, code)
{
    this.left = left;
    this.top = top;
    this.right = right;
    this.bottom = bottom;
    this.code = code;
};

var rc = {

    $editedText: null,

    buttons: [],

    init: function()
          {
              //              this.initButtons();
              this.$editedText = $('#edited_text');

              $('#et_from_dune').on('click', $.proxy(this.textFromDune, this));
              $('#et_to_dune').on('click', $.proxy(this.textToDune, this));
          },

    textFromDune: function()
                  {
                      app.ajaxGet(app.doUrl,
                                  {
                                      cmd: 'get_text'
                                  },

                                  $.proxy(this.processGetTextResponse, this));
                  },

    processGetTextResponse: function(data)
                            {
                                var params = data.getElementsByTagName('param');
                                for (var i = 0; i < params.length; ++i)
                                {
                                    var pName = params[i].getAttribute('name');
                                    var pVal = params[i].getAttribute('value');

                                    if (pName === 'text')
                                    {
                                        this.$editedText.val(pVal);
                                        break;
                                    }
                                    else if (pName === 'error_description')
                                    {
                                        alert(pVal);
                                        break;
                                    }
                                }
                            },

    textToDune: function()
                {
                    app.ajaxGet(app.doUrl,
                                {
                                    cmd: 'set_text',
                                    text: this.$editedText.val()
                                });
                },

    initButtons: function()
                 {
                     var btn = function(left, top, right, bottom, code)
                     {
                         return new RcBtn(left, top, right, bottom, code);
                     }

                     this.buttons.push(btn(5, 5, 60, 30,    'EF10BF00')); // Eject
                     this.buttons.push(btn(62, 5, 116, 30,  'B946BF00')); // Mute
                     this.buttons.push(btn(118, 5, 171, 30, 'BA45BF00')); // Mode
                     this.buttons.push(btn(173, 5, 228, 30, 'BC43BF00')); // Power
                     this.buttons.push(btn(4, 34, 59, 59,   'BF40BF00')); // A
                     this.buttons.push(btn(61, 34, 116, 59, 'E01FBF00')); // B
                     this.buttons.push(btn(118, 34, 171, 59, 'FF00BF00')); // C
                     this.buttons.push(btn(173, 34, 228, 59, 'BE41BF00')); // D
                     this.buttons.push(btn(35, 63, 90, 88, 'F40BBF00')); // 1
                     this.buttons.push(btn(92, 63, 147, 88, 'F30CBF00')); // 2
                     this.buttons.push(btn(149, 63, 203, 88, 'F20DBF00')); // 3
                     this.buttons.push(btn(35, 90, 90, 114, 'F10EBF00')); // 4
                     this.buttons.push(btn(92, 90, 147, 114, 'F00FBF00')); // 5
                     this.buttons.push(btn(149, 90, 203, 114, 'FE01BF00')); // 6
                     this.buttons.push(btn(35, 116, 90, 140, 'EE11BF00')); // 7
                     this.buttons.push(btn(92, 116, 147, 140, 'ED12BF00')); // 8
                     this.buttons.push(btn(149, 116, 203, 140, 'EC13BF00')); // 9
                     this.buttons.push(btn(35, 142, 90, 167, 'FA05BF00')); // Clear
                     this.buttons.push(btn(92, 142, 147, 167, 'F50ABF00')); // 0
                     this.buttons.push(btn(149, 142, 203, 167, 'BD42BF00')); // Select
                     this.buttons.push(btn(4, 159, 59, 194, 'AD52BF00')); // V+
                     this.buttons.push(btn(61, 159, 115, 194, 'F906BF00')); // Search
                     this.buttons.push(btn(117, 159, 171, 194, 'FD02BF00')); // Zoom
                     this.buttons.push(btn(173, 159, 228, 194, 'B44BBF00')); // P+
                     this.buttons.push(btn(4, 196, 59, 221, 'AC53BF00')); // V-
                     this.buttons.push(btn(63, 196, 171, 221, 'B14EBF00')); // Setup
                     this.buttons.push(btn(173, 196, 228, 221, 'B34CBF00')); // P-
                     this.buttons.push(btn(4, 225, 59, 250, 'AF50BF00')); // Info
                     this.buttons.push(btn(92, 225, 147, 250, 'EA15BF00')); // Up
                     this.buttons.push(btn(173, 225, 228, 250, 'F807BF00')); // Popup
                     this.buttons.push(btn(35, 252, 90, 277, 'E817BF00')); // Left
                     this.buttons.push(btn(92, 252, 147, 277, 'EB14BF00')); // Enter
                     this.buttons.push(btn(148, 252, 203, 277, 'E718BF00')); // Right
                     this.buttons.push(btn(4, 279, 59, 304, 'FB04BF00')); // Return
                     this.buttons.push(btn(92, 279, 147, 304, 'E916BF00')); // Down
                     this.buttons.push(btn(173, 279, 228, 304, 'AE51BF00')); // Top Menu
                     this.buttons.push(btn(4, 322, 59, 347, 'B748BF00')); // Play
                     this.buttons.push(btn(61, 322, 116, 347, 'E11EBF00')); // Pause
                     this.buttons.push(btn(118, 322, 172, 347, 'B649BF00')); // Prev
                     this.buttons.push(btn(174, 322, 228, 347, 'E21DBF00')); // Next
                     this.buttons.push(btn(4, 349, 59, 373, 'E619BF00')); // Stop
                     this.buttons.push(btn(61, 349, 116, 373, 'E51ABF00')); // Slow
                     this.buttons.push(btn(118, 349, 172, 373, 'E31CBF00')); // Rew
                     this.buttons.push(btn(175, 349, 230, 373, 'E41BBF00')); // Fwd
                     this.buttons.push(btn(4, 390, 59, 415, 'AB54BF00')); // Subtitles
                     this.buttons.push(btn(92, 390, 147, 415, 'B24DBF00')); // Angle Rotate
                     this.buttons.push(btn(173, 390, 228, 415, 'BB44BF00')); // Audio
                     this.buttons.push(btn(4, 424, 59, 449, '9F60BF00')); // Rec
                     this.buttons.push(btn(92, 424, 147, 449, 'B847BF00')); // Shuffle PIP
                     this.buttons.push(btn(173, 424, 228, 449, 'FC03BF00')); // URL

                     var map = '<map name="rc_buttons">';
                     for (var i = 0; i < this.buttons.length; ++i)
                     {
                         var coords = this.buttons[i].left
                                 + ',' + this.buttons[i].top
                                 + ',' + this.buttons[i].right
                                 + ',' + this.buttons[i].bottom
                         map += '<area href="javascript:{app.remoteControl(\'' + this.buttons[i].code + '\')}" coords="' + coords + '">';
                     }
                     map += '</map>';

                     console.log(map);

                 }
};


var settings = {


    init: function()
          {
              this.loadOptions();

              $('body').on('click.input.data-api', '[data-binopt]',
                           function(e)
                           {
                               var $this = $(this);
                               settings.setOption($this.data('binopt'), $this.is(':checked') ? 'true' : 'false');
                           });

//              $('#opt_show_covers').on('click', function()
//                                       {

//                                       } );

//              $('#opt_play_dwc').on('click', function()
//                                    {
//                                        settings.setOption('play_dwc', $(this).is(':checked') ? 'true' : 'false');
//                                    } );

              $('#opt_save_btn').on('click', $.proxy(this.save, this));
          },

    loadOptions: function()
                 {
                     app.ajaxGetJSON(app.do2Url,
                                     {
                                         cmd: 'option_list'
                                     },

                                     $.proxy(this.processOptionList, this));
                 },

    save: function()
          {
              app.ajaxPost(app.do2Url + '?cmd=set_option',
                           {
                               cover_files_names: $('#opt_cover_files_names').val(),
                               cover_files_exts: $('#opt_cover_files_exts').val()
                           },
                           function(){alert('Ok');} );

              return false;
          },

    processOptionList: function(data)
                       {
                           if ('options' in data)
                           {
                               $('#opt_cover_files_names').val(data.options.cover_files_names);
                               $('#opt_cover_files_exts').val(data.options.cover_files_exts);

                               $('input[data-binopt]').each(function()
                                                            {
                                                                var $this = $(this);
                                                                $this.attr('checked', data.options[$this.data('binopt')] === 'true');
                                                            });
                           }
                       },

    setOption: function(optName, optValue, callback)
               {
                   app.ajaxGetJSON(app.do2Url,
                                   {
                                       cmd: 'set_option',
                                       opt_name: optName,
                                       opt_value: optValue
                                   },
                                   callback);
               }
};



var newVersionInfoDlg = {

    $currVersion: null,
    $lastVersion: null,
    $description: null,

    init: function()
          {
              this.$currVersion = $('#current_version_title');
              this.$lastVersion = $('#last_version_title');
              this.$description = $('#last_version_description');


              $('#try_update_button').on('click', $.proxy(this.tryUpdate, this));
              $('#cancel_update_button').on('click', $.proxy(this.cancelUpdate, this));
          },

    tryUpdate: function()
               {
                   app.ajaxGetJSON(app.do2Url,
                                   {
                                       cmd: 'try_update'
                                   },

                                   $.proxy(this.processTryUpdateResponse, this));
               },

    cancelUpdate: function()
                  {
                      app.ajaxGetJSON(app.do2Url,
                                      {
                                          cmd: 'cancel_update'
                                      });
                  },

    processTryUpdateResponse: function(data)
                              {
                                  if ('message' in data && data.message === 'ok')
                                  {
                                      document.location.reload();
                                  }
                                  else
                                  {
                                      alert('error');
                                  }
                              },

    show: function(currVer, lastVer, lastVerDesc)
          {
              this.$currVersion.text(currVer);
              this.$lastVersion.text(lastVer);
              this.$description.html(lastVerDesc);

              $('#new_version_info_dlg').modal();
          }

};

var loader = {

    $loader: null,

    showCounter: 0,
    showTimer: null,
    errorTimer: null,

    init: function()
          {
              $('#reset_btn').on('click', $.proxy(this.reset, this));

              this.$loader = $('#loader');
          },

    reset: function()
           {
               app.reset();
           },

    show: function()
          {
              ++this.showCounter;

              if (this.showCounter === 1) this.startShowTimeout();
          },

    hide: function()
          {
              if (this.showCounter === 0) return;

              --this.showCounter;
              if (this.showCounter === 0)
              {
                  this.stopShowTimeout();
                  this.$loader.hide();
              }
          },

    toInfo: function()
                  {
                      if (this.$loader.hasClass('alert-error'))
                      {
                          this.$loader.removeClass('alert-error');
                          this.$loader.addClass('alert-info');
                          this.$loader.css({height: '32px'});
                      }
                  },

    toError: function()
             {
                 if (this.$loader.hasClass('alert-info'))
                 {
                     this.$loader.removeClass('alert-info');
                     this.$loader.addClass('alert-error');
                     this.$loader.css({height: '77px'});
                 }
             },

    _show: function()
           {
               this.showTimer = null;
               this.toInfo();
               this.$loader.css( { top: window.scrollY + 'px' } );
               this.$loader.show();
               this.startErrorTimeout();
           },

    startShowTimeout: function()
                      {
                          if (this.showTimer !== null) return;

                          this.showTimer = setTimeout($.proxy(this._show, this), 500);
                      },

    stopShowTimeout: function()
                     {
                         if (this.showTimer === null) return;

                         clearTimeout(this.showTimer);

                         this.showTimer = null;
                     },

    startErrorTimeout: function()
                       {
                           if (this.errorTimer !== null) return;

                           this.errorTimer = setTimeout($.proxy(this.error, this), 5000);
                       },

    stopErrorTimeout: function()
                      {
                          if (this.errorTimer === null) return;

                          clearTimeout(this.errorTimer);

                          this.errorTimer = null;
                      },
    error: function()
           {
               this.errorTimer = null;
               this.toError();
           }
};

$(function()
  {
      loader.init();
      app.init()
      browser.init();
      player.init();
      playlist.init();
      rc.init();
      settings.init();
      addNetworkSourceDlg.init();
      newVersionInfoDlg.init();
      addFavoriteDlg.init();
  });
