var app = {

    doUrl: location.href.substring(0, location.href.indexOf(location.pathname)) + '/cgi-bin/do',
    do2Url: location.href.substring(0, location.href.indexOf(location.pathname)) + '/cgi-bin/do2',

    keys: {

        play:    'B748BF00',
        pause:   'E11EBF00',
        stop:    'E619BF00',
        prev:    'B649BF00',
        next:    'E21DBF00',
        volUp:   'AD52BF00',
        volDown: 'AC53BF00',
        topMenu: 'AE51BF00'
    },

    init: function()
          {
              $('a[data-toggle="tab"]').on('shown',
                                           function (e)
                                           {
                                               if (e.target.hash === "#tools") settings.loadOptions();

                                               if (e.target.hash === '#player') player.start();
                                               else player.stop();

                                               if (e.target.hash === '#browser_network'
                                                       || e.target.hash === '#browser_local') browser.clearFileList();

                                           } );

              $('#check_for_updates_button').on('click', $.proxy(this.checkForUpdates, this));
          },

    play: function(media_url)
          {
              $.get(this.doUrl,
                    {
                        cmd: 'launch_media_url',
                        media_url: media_url
                    },
                    function(data)
                    {
                    } );
          },

    playDir: function (mediaUrl, startIndex)
             {
                 if (typeof startIndex === 'undefined') startIndex = 0;

                 $.get(this.doUrl,
                       {
                           cmd: 'start_playlist_playback',
                           media_url: mediaUrl,
                           start_index: startIndex
                       },
                       function(data)
                       {
                       } );
             },

    remoteControl: function(keyCode, responseHandler)
                   {
                       if (typeof responseHandler !== 'function') responseHandler = function() {};
                       $.get(this.doUrl,
                             {
                                 cmd: 'ir_code',
                                 ir_code: keyCode
                             },
                             responseHandler);
                   },

    addPosition: function(dxPos)
                 {
                     $.get(this.doUrl,
                           {
                               cmd: 'status'
                           },
                           function(data)
                           {
                               player.processPlayerState(data);
                               var pos = player.position + dxPos;
                               if (pos > player.duration) pos = player.duration - 1;
                               else if (pos < 0) pos = 1;
                               app.setPlaybackState({
                                                        position: pos
                                                    });
                           } );
                 },

    addVolume: function(dxVol)
               {
                   var vol = player.volume + dxVol;
                   if (vol > 100) vol = 100;
                   else if (vol < 0) vol = 0;
                   this.setPlaybackState({
                                             volume: vol
                                         });
               },

    setPlaybackState: function(state)
                      {
                          var data = {
                              cmd: 'set_playback_state',
                          };

                          for (var i in state) data[i] = state[i];

                          $.get(this.doUrl,
                                data,
                                function(data)
                                {
                                    player.processPlayerState(data);
                                } );
                      },

    checkForUpdates: function()
                     {
                         $.getJSON(this.do2Url,
                                   {
                                       cmd: 'check_new_version'
                                   },

                                   $.proxy(this.processCheckForUpdatesResponse, this))
                         .error(function(jqXHR) { alert(jqXHR.responseText); });
                     },

    processCheckForUpdatesResponse: function(data)
                                    {
                                        var currVersion = '0.0.0';
                                        var lastVersion = '0.0.0';
                                        var description = '';
                                        if ('currentVersionNumber' in data) currVersion = data.currentVersionNumber;
                                        if ('versionNumber' in data) lastVersion = data.versionNumber;
                                        if ('description' in data) description = data.description;

                                        var currVerArr = currVersion.split('.');
                                        var lastVerArr = lastVersion.split('.');

                                        if (currVerArr.length !== 3 || lastVerArr.length !== 3)
                                        {
                                            alert('error');
                                            return;
                                        }

                                        var nCurrVer =  parseInt(currVerArr[0] * 10000 + currVerArr[1] * 100 + currVerArr[2]);
                                        var nLastVer =  parseInt(lastVerArr[0] * 10000 + lastVerArr[1] * 100 + lastVerArr[2]);

                                        if (nCurrVer < nLastVer)
                                        {
                                            newVersionInfoDlg.show(currVersion, lastVersion, description);
                                        }
                                        else
                                        {
                                            alert('No new version');
                                        }
                                    }

}

var browser = {

    storagesCont: null,
    networkSourcesCont: null,
    dirCtrl: null,
    currDirCont: null,
    pathHistory: null,
    historyBackBtn: null,
    playCurrDirBtn: null,
    currDirLabelCont: null,
    currentDir: null,

    tplStorageButton: '<button class="btn btn-primary btn-large"></button>',
    tplStorageButtonSeparator: '<div class="storage-button-separator"></div>',

    tplNetworkSourceButton: '<div class="btn-toolbar"><div class="btn-group"><button class="btn btn-primary btn-large main"></button></div>'
                            + '</div>',

    tplNetworkSourceDelButton: '<div class="btn-group"><button class="btn btn-danger btn-large delete"><i class="icon-remove"></i></button></div>',

    tplFile: '<tr><td class="ctrl"></td><td class="name"></td></tr>',
    tplDirUrl: '<a href="javascript:"></a>',
    tplPlayButton: '<button class="btn btn-success btn-small btn-play">Play</button>',

    init: function()
          {
              this.storagesCont = $('#storages_cont');
              this.networkSourcesCont = $('#network_sources_cont');
              this.currDirCont = $('#curr_dir_cont');
              this.dirCtrl = $('#curr_dir_ctrl');

              this.historyBackBtn = $('#dir_ctrl_history_back');
              this.historyBackBtn.on('click', $.proxy(this.historyGoBack, this));

              this.playCurrDirBtn = $('#dir_ctrl_play_curr_dir');
              this.playCurrDirBtn.on('click', $.proxy(this.playCurrDir, this));

              this.currDirLabelCont = $('#dir_ctrl_curr_dir_label');

              this.dirCtrlShow(false);
              this.currDirShow(false);

              $('#refresh_btn').on('click', this.refreshStoragesList);

              $.getJSON(app.do2Url,
                        {
                            cmd: 'storage_list'
                        },

                        $.proxy(this.processStorageList, this));

              this.updateNetworkSources();

              this.reinitContext();
          },

    updateNetworkSources: function()
                          {
                              $.getJSON(app.do2Url,
                                        {
                                            cmd: 'network_source_list'
                                        },

                                        $.proxy(this.processNetworkSourceList, this));
                          },

    reinitContext: function()
                   {
                       this.currentDir = {
                           path: null,
                           mediaUrl: null,
                           hasSubdir: false
                       };

                       this.pathHistory = [];
                   },

    refreshStoragesList: function()
                         {
                             app.remoteControl(app.keys.topMenu,
                                               function()
                                               {
                                                   document.location.reload();
                                               } );
                         },

    processStorageList: function(data)
                        {
                            this.storagesCont.empty();

                            if (data.storages.length === 0)
                            {
                                var refresh = $(this.tplStorageButton);
                                refresh.text('NO STORAGES! REFRESH');
                                refresh.on('click', this.refreshStoragesList);

                                this.storagesCont.append(refresh);
                                return;
                            }

                            for (var i = 0; i < data.storages.length; ++i)
                            {
                                if (i > 0)
                                {
                                    var sep = $(this.tplStorageButtonSeparator);
                                    this.storagesCont.append(sep);
                                }

                                var s = data.storages[i];
                                var btn = $(this.tplStorageButton);
                                btn.text(s.title);
                                btn.data('path', s.name);
                                btn.on('click', function()
                                       {
                                           browser.reinitContext();
                                           browser.showDir($(this).data('path'));
                                       } );


                                this.storagesCont.append(btn);
                            }
                        },

    processNetworkSourceList: function(data)
                              {
                                  this.networkSourcesCont.empty();

                                  if (data.sources.length === 0)
                                  {
                                      var add = $(this.tplStorageButton);
                                      add.text('ADD SOURCE');
                                      add.on('click',
                                             function(){ $('#add_network_source_dlg').modal('show')});

                                      this.networkSourcesCont.append(add);
                                      return;
                                  }

                                  for (var i = 0; i < data.sources.length; ++i)
                                  {
                                      if (i > 0)
                                      {
                                          var sep = $(this.tplStorageButtonSeparator);
                                          this.networkSourcesCont.append(sep);
                                      }

                                      var s = data.sources[i];
                                      var btnGroup = $(this.tplNetworkSourceButton);

                                      var btn = btnGroup.find('.main');
                                      btn.text(s.title + ' (' + s.type + ')');
                                      btn.data('path', s.name);
                                      btn.on('click', function()
                                             {
                                                 browser.reinitContext();
                                                 browser.showDir($(this).data('path'));
                                             } );

                                      if (s.is_persist === '0')
                                      {
                                          var del = $(this.tplNetworkSourceDelButton);
                                          del.data('network_source_key', s.key);
                                          del.on('click', function()
                                                 {
                                                     browser.delNetworkSource($(this).data('network_source_key'))
                                                 } );

                                          btnGroup.append(del);
                                      }

                                      this.networkSourcesCont.append(btnGroup);
                                  }
                              },

    delNetworkSource: function(key)
                      {
                          if (window.confirm('Are you sure?'))
                          {
                              $.getJSON(app.do2Url,
                                        {
                                            cmd: 'network_source_del',
                                            source_key: key
                                        },
                                        $.proxy(this.updateNetworkSources, this))
                              .error(function(jqXHR) { alert(jqXHR.responseText); });
                          }
                      },

    processFileList: function(data)
                     {
                         this.currDirCont.empty();
                         this.currDirShow(true);

                         for (var i = 0; i < data.files.length; ++i)
                         {
                             var f = data.files[i];

                             var item = $(this.tplFile);

                             if ('path' in f)
                             {
                                 var a = $(this.tplDirUrl);
                                 a.text(f.name);

                                 var $fnCont = item.find('.name');
                                 $fnCont.data('path', f.path);
                                 $fnCont.on('click', function()
                                            {
                                                browser.showDir($(this).data('path'));
                                            } );

                                 if ('cover' in f)
                                 {
                                     var $table = $('<table class="twc"><tr><td class="cover"></td><td class="name"></td></tr></table>');

                                     $table.find('.cover').append($('<img src="' + f.cover +'" class="cover" />'));
                                     $table.find('.name').append(a);

                                     $fnCont.append($table);
                                 }
                                 else
                                 {
                                     $fnCont.append(a);
                                 }

                                 this.currentDir.hasSubdir = true;
                             }
                             else
                             {
                                 item.find('.name').text(f.name);
                             }

                             var play = null;
                             if ('index' in f && data.curr_dir_media_url !== '')
                             {
                                 play = $(this.tplPlayButton);
                                 play.data('media_url', data.curr_dir_media_url);
                                 play.data('start_index', f.index);
                                 play.on('click', function()
                                         {
                                             $this = $(this);
                                             app.playDir($this.data('media_url'), $this.data('start_index'));
                                         } );

                                 item.find('.ctrl').append(play);
                             }
                             else if ('media_url' in f)
                             {
                                 play = $(this.tplPlayButton);
                                 if ('path' in f) play.text('Play Directory');

                                 play.data('media_url', f.media_url);
                                 play.on('click', function()
                                         {
                                             app.play($(this).data('media_url'));
                                         } );

                                 item.find('.ctrl').append(play);
                             }

                             this.currDirCont.append(item);

                             this.moveToFiles();
                         }

                         this.setCurrDirMediaUrl(data.curr_dir_media_url);
                     },

    showDir: function(path, back)
             {
                 if (typeof(back) === 'undefined') back = false;

                 if (!back && this.currentDir.path !== null) this.pathHistory.push(this.currentDir.path);
                 this.currentDir.path = path;

                 this.historyBackShow(this.pathHistory.length > 0);
                 this.currDirLabelCont.text(path.split('/').pop());

                 $.getJSON(app.do2Url,
                           {
                               cmd: 'file_list',
                               path: path

                           },
                           $.proxy(this.processFileList, this)  )
                 .error(function(jqXHR){browser.processInvalidPath();alert(jqXHR.responseText);});
             },

    processInvalidPath: function()
                        {
                            this.clearFileList();
                        },

    clearFileList: function()
                   {
                       this.currDirShow(false);
                       this.currDirCont.empty();
                       this.reinitContext();
                   },

    historyGoBack: function()
                   {
                       if (this.pathHistory.length === 0) return;

                       this.showDir(this.pathHistory.pop(), true);
                   },

    playCurrDir: function()
                 {
                     app.playDir(this.currentDir.mediaUrl);
                 },

    dirCtrlShow: function(show)
                 {
                     if (show) this.dirCtrl.show();
                     else this.dirCtrl.hide();
                 },

    currDirShow: function(show)
                 {
                     if (show) this.currDirCont.parent().show();
                     else this.currDirCont.parent().hide();
                 },

    updateDirCtrlState: function()
                        {
                            var btns = this.dirCtrl.children('button');
                            this.dirCtrlShow(true);
                            for (var i = 0; i < btns.length; ++i)
                            {
                                if ($(btns[i]).is(':visible')) return;
                            }

                            this.dirCtrlShow(false);
                        },

    historyBackShow: function(show)
                     {
                         if (show) this.historyBackBtn.show();
                         else this.historyBackBtn.hide();

                         this.updateDirCtrlState();
                     },

    setCurrDirMediaUrl: function(media_url)
                        {
                            this.currentDir.mediaUrl = media_url;
                            this.playCurrDirShow(this.currentDir.mediaUrl !== '');
                        },

    playCurrDirShow: function(show)
                     {
                         if (show) this.playCurrDirBtn.show();
                         else this.playCurrDirBtn.hide();

                         this.updateDirCtrlState();
                     },

    moveToFiles: function()
                 {
                     var loc = document.location + '';
                     if (loc.indexOf('#files') === -1) loc += '#files';
                     document.location = loc;
                 }
};

var addNetworkSourceDlg = {

    $type: null,
    $title: null,
    $address: null,
    $path: null,
    $user: null,
    $password: null,
    $protocol: null,

    init: function()
          {
              this.$type = $('#network_source_type');
              this.$title = $('#network_source_title');
              this.$address = $('#network_source_address');
              this.$path = $('#network_source_path');
              this.$user = $('#network_source_user');
              this.$password = $('#network_source_password');
              this.$protocol = $('#network_source_protocol');

              $('#add_network_source_dlg').on('show', $.proxy(this.show, this));
              $('#network_source_type').on('change', $.proxy(this.initState, this));

              $('#network_source_add_btn').on('click', $.proxy(this.addNetworkSource, this));
          },

    show: function()
          {
              this.clear();
              this.initState();
          },

    clear: function()
           {
               this.$type.val('0');
               this.$title.val('');
               this.$address.val('');
               this.$path.val('');
               this.$user.val('');
               this.$password.val('');
               this.$protocol.val('0');
           },

    initState: function()
               {
                   if (this.$type.val() === '0')
                   {
                       this.$protocol.hide();
                       this.$user.show();
                       this.$password.show();
                   }
                   else
                   {
                       this.$protocol.show();
                       this.$user.hide();
                       this.$password.hide();
                   }
               },

    addNetworkSource: function()
                      {
                          $.getJSON(app.do2Url,
                                    {
                                        cmd: 'network_source_add',
                                        type: this.$type.val(),
                                        title: this.$title.val(),
                                        address: this.$address.val(),
                                        path: this.$path.val(),
                                        user: this.$user.val(),
                                        password: this.$password.val(),
                                        protocol: this.$protocol.val()
                                    },

                                    $.proxy(this.processAddNetworkSourceResponse, this) )
                          .error(function(jqXHR) { alert(jqXHR.responseText); });
                      },

    processAddNetworkSourceResponse: function()
                                     {
                                         browser.updateNetworkSources();
                                         $('#add_network_source_dlg').modal('hide');
                                     },
};

var player = {

    progressBar: null,
    currentTrackLabel: null,
    volumeLabel: null,
    counter: null,

    currentTrack: '',
    volume: 0,
    duration: 0,
    position: 0,

    timer: null,


    init: function()
          {
              this.counter = $('#player_timer');
              this.progressBar = $('#progress_bar');
              this.volumeLabel = $('#vol_label');
              this.currentTrackLabel = $('#curr_track_label');

              var btnClick = function() { app.remoteControl($(this).data('key_code')); }
              $('#play').data('key_code', app.keys.play).on('click', btnClick);
              $('#pause').data('key_code', app.keys.pause).on('click', btnClick);
              $('#stop').data('key_code', app.keys.stop).on('click', btnClick);
              $('#prev').data('key_code', app.keys.prev).on('click', btnClick);
              $('#next').data('key_code', app.keys.next).on('click', btnClick);


              $('#volDownX1').on('click', function() {
                                     app.addVolume(-2);
                                 });
              $('#volUpX1').on('click', function() {
                                   app.addVolume(2);
                               });

              $('#volDownX2').on('click', function() {
                                     app.addVolume(-10);
                                 } );

              $('#volUpX2').on('click', function() {
                                   app.addVolume(10);
                               } );

              $('#bX2').on('click', function(){
                               app.addPosition(-60);
                           } );

              $('#bX1').on('click', function(){
                               app.addPosition(-10);
                           } );

              $('#fX1').on('click', function(){
                               app.addPosition(10);
                           } );

              $('#fX2').on('click', function(){
                               app.addPosition(60);
                           } );
          },

    setProgress: function(percents)
                 {
                     this.progressBar.css({width: percents + '%'});
                 },

    setProgress2: function(val, from)
                  {
                      this.setProgress(val * 100 / from);
                  },

    processPlayerState: function(data)
                        {
                            var params = data.getElementsByTagName('param');
                            for (var i = 0; i < params.length; ++i)
                            {
                                var pName = params[i].getAttribute('name');
                                var pVal = params[i].getAttribute('value');
                                switch (pName)
                                {
                                case 'playback_volume':
                                    this.volume = parseInt(pVal);
                                    break;

                                case 'playback_position':
                                    this.position = parseInt(pVal);
                                    break;

                                case 'playback_duration':
                                    this.duration = parseInt(pVal);
                                    break;

                                case 'playback_url':
                                    this.currentTrack = pVal.split('/').pop();
                                    break;
                                }
                            }

                            this.updateUi();
                        },

    updateUi: function()
              {
                  this.setProgress2(this.position, this.duration);
                  this.volumeLabel.text('Vol. ' + this.volume + '%');
                  this.currentTrackLabel.text(this.currentTrack);


                  // ---- counter
                  var result = '';
                  var h = Math.floor(this.position / (60 * 60));
                  var m = Math.floor( (this.position - h * 60 * 60) / 60);
                  var s = this.position - h * 60 * 60 - m * 60;
                  if (h < 10) h = '0' + h;
                  if (m < 10) m = '0' + m;
                  if (s < 10) s = '0' + s;

                  result += h + ':' + m + ':' + s;

                  h = Math.floor(this.duration / (60 * 60));
                  m = Math.floor( (this.duration - h * 60 * 60) / 60);
                  s = this.duration - h * 60 * 60 - m * 60;
                  if (h < 10) h = '0' + h;
                  if (m < 10) m = '0' + m;
                  if (s < 10) s = '0' + s;

                  result += ' / ' + h + ':' + m + ':' + s;
                  this.counter.text(result);

              },

    start: function()
           {
               if (this.timer !== null) return;

               this._playerProcess();
           },

    _playerProcess: function()
                    {
                        $.get(app.doUrl,
                              {
                                  cmd: 'status'
                              },
                              function(data)
                              {
                                  player.processPlayerState(data);
                                  player._playerProcessWrapper();
                              } );
                    },

    _playerProcessWrapper: function()
                           {
                               this.timer = setTimeout(this._playerProcess, 3000);

                           },

    stop: function()
          {
              clearTimeout(this.timer);
              this.timer = null;

              this.duration = 0;
              this.position = 0;
              this.updateUi();
          }
};


var RcBtn = function(left, top, right, bottom, code)
{
    this.left = left;
    this.top = top;
    this.right = right;
    this.bottom = bottom;
    this.code = code;
};

var rc = {

    buttons: [],

    init: function()
          {
              //              this.initButtons();
          },

    initButtons: function()
                 {
                     var btn = function(left, top, right, bottom, code)
                     {
                         return new RcBtn(left, top, right, bottom, code);
                     }

                     this.buttons.push(btn(5, 5, 60, 30,    'EF10BF00')); // Eject
                     this.buttons.push(btn(62, 5, 116, 30,  'B946BF00')); // Mute
                     this.buttons.push(btn(118, 5, 171, 30, 'BA45BF00')); // Mode
                     this.buttons.push(btn(173, 5, 228, 30, 'BC43BF00')); // Power
                     this.buttons.push(btn(4, 34, 59, 59,   'BF40BF00')); // A
                     this.buttons.push(btn(61, 34, 116, 59, 'E01FBF00')); // B
                     this.buttons.push(btn(118, 34, 171, 59, 'FF00BF00')); // C
                     this.buttons.push(btn(173, 34, 228, 59, 'BE41BF00')); // D
                     this.buttons.push(btn(35, 63, 90, 88, 'F40BBF00')); // 1
                     this.buttons.push(btn(92, 63, 147, 88, 'F30CBF00')); // 2
                     this.buttons.push(btn(149, 63, 203, 88, 'F20DBF00')); // 3
                     this.buttons.push(btn(35, 90, 90, 114, 'F10EBF00')); // 4
                     this.buttons.push(btn(92, 90, 147, 114, 'F00FBF00')); // 5
                     this.buttons.push(btn(149, 90, 203, 114, 'FE01BF00')); // 6
                     this.buttons.push(btn(35, 116, 90, 140, 'EE11BF00')); // 7
                     this.buttons.push(btn(92, 116, 147, 140, 'ED12BF00')); // 8
                     this.buttons.push(btn(149, 116, 203, 140, 'EC13BF00')); // 9
                     this.buttons.push(btn(35, 142, 90, 167, 'FA05BF00')); // Clear
                     this.buttons.push(btn(92, 142, 147, 167, 'F50ABF00')); // 0
                     this.buttons.push(btn(149, 142, 203, 167, 'BD42BF00')); // Select
                     this.buttons.push(btn(4, 159, 59, 194, 'AD52BF00')); // V+
                     this.buttons.push(btn(61, 159, 115, 194, 'F906BF00')); // Search
                     this.buttons.push(btn(117, 159, 171, 194, 'FD02BF00')); // Zoom
                     this.buttons.push(btn(173, 159, 228, 194, 'B44BBF00')); // P+
                     this.buttons.push(btn(4, 196, 59, 221, 'AC53BF00')); // V-
                     this.buttons.push(btn(63, 196, 171, 221, 'B14EBF00')); // Setup
                     this.buttons.push(btn(173, 196, 228, 221, 'B34CBF00')); // P-
                     this.buttons.push(btn(4, 225, 59, 250, 'AF50BF00')); // Info
                     this.buttons.push(btn(92, 225, 147, 250, 'EA15BF00')); // Up
                     this.buttons.push(btn(173, 225, 228, 250, 'F807BF00')); // Popup
                     this.buttons.push(btn(35, 252, 90, 277, 'E817BF00')); // Left
                     this.buttons.push(btn(92, 252, 147, 277, 'EB14BF00')); // Enter
                     this.buttons.push(btn(148, 252, 203, 277, 'E718BF00')); // Right
                     this.buttons.push(btn(4, 279, 59, 304, 'FB04BF00')); // Return
                     this.buttons.push(btn(92, 279, 147, 304, 'E916BF00')); // Down
                     this.buttons.push(btn(173, 279, 228, 304, 'AE51BF00')); // Top Menu
                     this.buttons.push(btn(4, 322, 59, 347, 'B748BF00')); // Play
                     this.buttons.push(btn(61, 322, 116, 347, 'E11EBF00')); // Pause
                     this.buttons.push(btn(118, 322, 172, 347, 'B649BF00')); // Prev
                     this.buttons.push(btn(174, 322, 228, 373, 'E21DBF00')); // Next
                     this.buttons.push(btn(4, 349, 59, 373, 'E619BF00')); // Stop
                     this.buttons.push(btn(61, 322, 116, 373, 'E51ABF00')); // Slow
                     this.buttons.push(btn(118, 322, 172, 373, 'E31CBF00')); // Rew
                     this.buttons.push(btn(175, 322, 230, 373, 'E41BBF00')); // Fwd
                     this.buttons.push(btn(4, 390, 59, 415, 'AB54BF00')); // Subtitles
                     this.buttons.push(btn(92, 390, 147, 415, 'B24DBF00')); // Angle Rotate
                     this.buttons.push(btn(173, 390, 228, 415, 'BB44BF00')); // Audio
                     this.buttons.push(btn(4, 424, 59, 449, '9F60BF00')); // Rec
                     this.buttons.push(btn(92, 424, 147, 449, 'B847BF00')); // Shuffle PIP
                     this.buttons.push(btn(173, 424, 228, 449, 'FC03BF00')); // URL

                     var map = '<map name="rc_buttons">';
                     for (var i = 0; i < this.buttons.length; ++i)
                     {
                         var coords = this.buttons[i].left
                                 + ',' + this.buttons[i].top
                                 + ',' + this.buttons[i].right
                                 + ',' + this.buttons[i].bottom
                         map += '<area href="javascript:{app.remoteControl(\'' + this.buttons[i].code + '\')}" coords="' + coords + '">';
                     }
                     map += '</map>';

                     console.log(map);

                 }
};


var settings = {


    init: function()
          {
              this.loadOptions();

              $('#opt_show_covers').on('click', function()
                                       {
                                           settings.setOption('show_covers', $(this).is(':checked') ? 'true' : 'false');
                                       } );

              $('#opt_play_dwc').on('click', function()
                                    {
                                        settings.setOption('play_dwc', $(this).is(':checked') ? 'true' : 'false');
                                    } );

              $('#opt_save_btn').on('click', $.proxy(this.save, this));
          },

    loadOptions: function()
                 {
                     $.getJSON(app.do2Url,
                               {
                                   cmd: 'option_list'
                               },

                               $.proxy(this.processOptionList, this));
                 },

    save: function()
          {
              this.setOption('cover_files', $('#opt_cover_files').val(), function(){alert('Ok');});

              return false;
          },

    processOptionList: function(data)
                       {
                           if ('options' in data)
                           {
                               $('#opt_show_covers').attr('checked', data.options.show_covers === 'true');
                               $('#opt_play_dwc').attr('checked', data.options.play_dwc === 'true');
                               $('#opt_cover_files').val(data.options.cover_files);
                           }
                       },

    setOption: function(optName, optValue, callback)
               {
                   $.getJSON(app.do2Url,
                             {
                                 cmd: 'set_option',
                                 opt_name: optName,
                                 opt_value: optValue
                             },
                             callback)
                   .error(function(jqXHR) { alert(jqXHR.responseText); });
               }
};



var newVersionInfoDlg = {

    $currVersion: null,
    $lastVersion: null,
    $description: null,

    init: function()
          {
              this.$currVersion = $('#current_version_title');
              this.$lastVersion = $('#last_version_title');
              this.$description = $('#last_version_description');


              $('#try_update_button').on('click', $.proxy(this.tryUpdate, this));
          },

    tryUpdate: function()
               {
                   $.getJSON(app.do2Url,
                             {
                                 cmd: 'try_update'
                             },

                             $.proxy(this.processTryUpdateResponse, this))
                   .error(function(jqXHR) { alert(jqXHR.responseText); });
               },

    processTryUpdateResponse: function(data)
                              {
                                  if ('message' in data && data.message === 'ok')
                                  {
                                      document.location.reload();
                                  }
                                  else
                                  {
                                      alert('error');
                                  }
                              },

    show: function(currVer, lastVer, lastVerDesc)
          {
              this.$currVersion.text(currVer);
              this.$lastVersion.text(lastVer);
              this.$description.html(lastVerDesc);

              $('#new_version_info_dlg').modal();
          }

};

$(function()
  {
      app.init()
      browser.init();
      player.init();
      rc.init();
      settings.init();
      addNetworkSourceDlg.init();
      newVersionInfoDlg.init();
  });
