#!/bin/sh

ROOT_DIR="/persistfs/extendrc"

func_install()
{
	mkdir -p /config/boot
	
	# copy extendrc boot daemon
	cp -f $ROOT_DIR/boot/extendrcbd /config/boot
}

func_start()
{
	## add profile extension
	#echo "[ -r $ROOT_DIR/etc/profile ] && . $ROOT_DIR/etc/profile" >> /etc/profile

	## update inittab for shutdown callback
	## if not LTU installed
	if [ ! -f "/sbin/onshutdown.sh" ] ; then
		## then update /etc/inittab
		cp -f "$ROOT_DIR/sbin/extendrc_onshutdown.sh" /sbin
		if [ "`grep '::shutdown:/sbin/extendrc_onshutdown.sh' /etc/inittab`" = "" ] ; then
			sed "s|::shutdown:/bin/umount -a -r|::shutdown:/sbin/extendrc_onshutdown.sh|" -i /etc/inittab
			kill -HUP 1
		fi
	fi

	## start portmap
	$ROOT_DIR/etc/init.d/K19portmap start
	
	## start extend remote control
	if [ ! -d /tmp/www/cgi-bin ] ; then
		mkdir -p /tmp/www/cgi-bin
	fi
	ln -sf "$ROOT_DIR/bin/dunerc" "/tmp/www/cgi-bin/do2"
	ln -sf "$ROOT_DIR/share/client" "/tmp/www/rc"
}

func_stop()
{
	## stop portmap
	$ROOT_DIR/etc/init.d/K19portmap stop
}

case "$1" in
start)
	func_start
	;;
stop)
	func_stop
	;;
install)
	func_install
	func_start
	;;
*)
	echo "Usage: $0 {start|stop|install}"
esac
